%PARAMETERS
Npart = 200;              % Number of trajectories to compute
Nsteps = 10000;           % Maximum number of time steps per trajectory
Nx = 370;                 % Number of E-field grid points in x-direction 
Ny = 192;                 % Number of E-field grid points in y-direction 
Nz = 192;                 % Number of E-field grid points in z-direction 
xmax = 63600000;       % Upper x-boundary [m] of Efield grid, GSW system
xmin = -380400000;     % Lower x-boundary [m] of Efield grid, GSW system
ymax = 115200000;      % Upper y-boundary [m] of Efield grid, GSW system
ymin = -115200000;     % Lower y-boundary [m] of Efield grid, GSW system
zmax = 115200000;      % Upper z-boundary [m] of Efield grid, GSW system
zmin = -115200000;     % Lower z-boundary [m] of Efield grid, GSW system
initialiser = 2;       % Initialisation method
                       % 1: Maxwellian in cube; parameters as above
                       % 2: Read position, v_par, vth_perp from file;
                       % one particle per line. (ExB/B^2 added by program)
                       % 3: Read position, v_par, v_perp from file;
                       % one particle per line.(ExB/B^2 not added by program)
scdatafilename = 'PlasmaMantle.dat'; % Input file name for initialiser=2
                                     % & initialiser=3
altobs = 1000000;      % Obstacle altitude below which no trajectories
                       % are calculated.

mass = 2.676190e-26;    % Ion mass [kg]
msw = 1.800400e-27;     % solar wind unit mass
charge = 1.602177e-19;  % Ion charge [As]
dt = 10;                % Time step [s]

ByIMF = 7.820000e+00;     % IMF By component for use with Tsyganenko [nT]
BzIMF = 3.805000e+00;     % IMF Bz component for use with Tsyganenko [nT]
Tsygvxgse = -5.525000e+02;% Solar wind vx [km/s] for use with Tsyganenko
Tsygvygse = 1.230000e+01; % Solar wind vy [km/s] for use with Tsyganenko
Tsygvzgse = 4.490000e+01; % Solar wind vz [km/s] for use with Tsyganenko
dhtime = 4.750000e+00;    % Decimal hours for use with Tsyganenko
iday = 180;               % Day for use with Tsyganenko
iyear = 2006;             % Year for use with Tsyganenko
Dst = -4;                 % Dst index for use with Tsyganenko
pdyn = 5.130000e+00;      % Solar wind dynamic pressure for use with
                          % Tsyganenko [nPa]

% ----- Setup of the program functionality ---- %
forward = 1;       % To go forward in time: +1 to go backward: -1
dumpfields = 'yes';% Set to 'yes' if you wish to have potential and
                   % E-fields written to files.
usedump = 'no';    % If yes, potential and E-fields are loaded from dump
Parallel = 'y';    % Dimension along which the field calculation is
                   % parallelised.

% ---- Timestep parameters ---- %
number_of_steps = 20;          % number of steps during one gyroperiod
maximum_step_length = 1.0e5;   % maximum length of steps, 
                               % when calculated based on velocity [m]
saving_step_length = 100000;   % step length between two saved trajectory 
                               % positions [m]
use_gyro_period = 'yes';       % calculate timestep based on gyroperiod
use_max_step_length = 'no';    % calculate timestep based on velocity

% ----- Weimer model parameters ---- %
ALindex = 0;      % ALindex: (optional) AL index in nT
UseAL = 'off';    % If this is 'on' ALindex is used, otherwise not.

%END
